<?php
/*
Extension Name: Filters that run on specific shortcode values.
Extension Preview: -
Description:
Version: 1.0
Author: Crumina
Author URI: https://wpcode.pro/
*/


if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

// Live editor template for row shortcode.

function crumina_custom_live_shortcode_filter( $atts, $base ) {

	$live_tmpl = get_template_directory() . '/kingcomposer/live_editor/';
	if ( $base == 'kc_row' ) {
		$atts['live_editor'] = $live_tmpl . 'crum_row.php';
	}
	return $atts; // required
}
add_filter( 'kc_add_map', 'crumina_custom_live_shortcode_filter', 0, 2 );

// This filter will run before wp_header

function crumina_row_animation_filter( $atts ) {
	if ( ! empty( $atts['row_animation'] ) ) {
		wp_enqueue_script( 'scrollmagic-velocity' );
	}
}
add_filter( 'shortcode_kc_row', 'crumina_row_animation_filter', 99 );

/*function crumina_kc_tabs_js( $atts ) {

	if ( isset( $atts['type'] ) && ( $atts['type'] != 'slider_tabs' ) ) {
		wp_enqueue_script( 'jquery-ui-tabs' );
	}
}
add_filter( 'shortcode_kc_tabs', 'crumina_kc_tabs_js', 9999 );*/

/**
 * Enable YouTube Video BG for our KingComposer Rows
 */
function seosight_include_youtube_api_js( $atts ) {
	if ( isset( $atts[ 'video_bg' ] ) && $atts[ 'video_bg' ] == 'yes' ) {
		wp_register_script( 'kc-youtube-iframe-api', 'https://www.youtube.com/iframe_api', null, '', true );
		wp_enqueue_script( 'kc-youtube-iframe-api' );
	}

	return $atts;
}

add_filter( 'shortcode_kc_row', 'seosight_include_youtube_api_js' );